#   Cisco Secure Network Analytics & Cisco ISE Integration

## Overview

- **Secure Network Analytics**: Provides network-wide threat visibility, behavioral monitoring, and anomaly detection.
- **Cisco ISE**: Focuses on threat containment and enforcement using Security Group Tag (SGT)-based TrustSec services.

---

## Threat Visibility and Detection

- Secure Network Analytics delivers data intelligence across the network:
    - Endpoint and traffic discovery
    - Behavioral monitoring
    - Anomaly detection
- Traditional networks often lack full visibility of packets inside the network after perimeter security.
- Threats missed by the firewall or introduced via air gaps (e.g., USB drives, off-premises infected devices) can spread undetected.

---

## Threat Response and Containment

- Integration enables rapid incident response:
    - Secure Network Analytics detects alarms related to internal hosts.
    - It can notify Cisco ISE to take containment actions.
- **Quarantine Process:**
    - Cisco ISE assigns a Quarantine SGT to the compromised endpoint.
    - The endpoint is immediately isolated from the rest of the network as per security policy.
- Quarantine SGT = SGT denied connectivity.

---

## Integration Details

- **Communication Channels:**
    - Threat visibility between endpoints and Secure Network Analytics is via NetFlow.
    - Secure Network Analytics and Cisco ISE integrate using pxGrid (Platform Exchange Grid).
- **pxGrid Functionality:**
    - Unified framework for sharing contextual user and device information.
    - Cisco ISE publishes session and context data; partners like Secure Network Analytics subscribe and take actions.
- **Enriched Security Context:**
    - Cisco ISE provides user identity and device type information.
    - Combined with flow data, delivers a unified, comprehensive network view.

---

## Mitigation and Policy Management

- Security administrators can:
    - Quarantine, unquarantine, or mark hosts as safe directly from the Secure Network Analytics Manager.
    - Create new mitigation policies in response to threats.
- Secure Network Analytics registers as a pxGrid client to Cisco ISE, subscribes to Adaptive Network Control (ANC), and can perform mitigation actions automatically.
- Mitigation integration streamlines incident response and helps prevent data breaches.

---

**Summary:**  
By integrating Cisco Secure Network Analytics with Cisco ISE via pxGrid, organizations gain end-to-end threat visibility, accelerated incident response, and automated threat containment, unifying detection, context, and enforcement across the enterprise network